**************************************************************************************************
******************* 04. MAIN TABLES AND GRAPHS ***************************************************
*************************DATE: JAN 2022 **********************************************************
************************ AUTHOR: KIM NGUYEN ******************************************************
**************************************************************************************************


clear all
set more off
set maxvar 30000
set matsize 10000

//Load data for analysis
use "\\Output\covenants_analysis.dta", clear

//Set up panel
xtset id year, delta(1)

//TABLE 1. Financial Statistics by Usage and Type of Debt Covenants

tabstat revenue debt cash assets investment staffexpenses roepreferred gearingratiopreferred dte icr if cov==0 & debt>0, stats(median)
tabstat revenue debt cash assets investment staffexpenses roepreferred gearingratiopreferred dte icr if cov==1, stats(median)
tabstat revenue debt cash assets investment staffexpenses roepreferred gearingratiopreferred dte icr if breach==1, stats(median)
tabstat revenue debt cash assets investment staffexpenses roepreferred gearingratiopreferred dte icr if abc==1, stats(median)
tabstat revenue debt cash assets investment staffexpenses roepreferred gearingratiopreferred dte icr if icc==1, stats(median)
tabstat revenue debt cash assets investment staffexpenses roepreferred gearingratiopreferred dte icr if oec==1, stats(median)


//FIGURE 3. Trends in Corporate Debt Covenants
tabstat cov, by(year) columns(statistics)
tabstat breach, by(year) columns(statistics)
tabstat breach if cov==1, by(year) columns(statistics)
tabstat abc if (icc == 1 | oec == 1 | abc == 1), by(year) columns(statistics)
tabstat icc if (icc == 1 | oec == 1 | abc == 1), by(year) columns(statistics)
tabstat oec if (icc == 1 | oec == 1 | abc == 1), by(year) columns(statistics)

** Robustness
preserve
drop if breach==1
bysort id: egen sumcov = sum(cov)
sum sumcov
keep if sumcov>=2
tabstat abc if (icc == 1 | oec == 1 | abc == 1), by(year) columns(statistics)
tabstat icc if (icc == 1 | oec == 1 | abc == 1), by(year) columns(statistics)
tabstat oec if (icc == 1 | oec == 1 | abc == 1), by(year) columns(statistics)
restore

** Breaching by cov type
tabstat breach if covtype_c==1, by(year) columns(statistics)
tabstat breach if covtype_c==2, by(year) columns(statistics)

//FIGURE 4 TOP. Manipulation ICC
rddensity icr if debt>0 & covtype_c==1 & icr<1000 & icr>-1000, pl plot_range(-20 22) c(2) nohist

//FIGURE 4 BOTTOM. Manipulation NICC
rddensity icr if debt>0 & covtype_c==2 & icr<1000 & icr>-1000, pl plot_range(-20 22) c(2) nohist

//FIGURE 5. Ex-ante Treatment Group vs. Control Group - Investment and Staff Expenses

foreach i in Dinvestment Dstaffexpenses{
g l1`i'= l.`i'
g l2`i'= l.l1`i'
g l3`i'= l.l2`i'
g f1`i'= f.`i'
g f2`i'= f.f1`i'
g f3`i'= f.f2`i'
}

tabstat l3Dinvestment l2Dinvestment l1Dinvestment Dinvestment f1Dinvestment f2Dinvestment f3Dinvestment if Ldisg==0, stats(mean)
tabstat l3Dinvestment l2Dinvestment l1Dinvestment Dinvestment f1Dinvestment f2Dinvestment f3Dinvestment if Ldisg==1, stats(mean)

tabstat l3Dstaffexpenses l2Dstaffexpenses l1Dstaffexpenses Dstaffexpenses f1Dstaffexpenses f2Dstaffexpenses f3Dstaffexpenses if Ldisg==0, stats(mean)
tabstat l3Dstaffexpenses l2Dstaffexpenses l1Dstaffexpenses Dstaffexpenses f1Dstaffexpenses f2Dstaffexpenses f3Dstaffexpenses if Ldisg==1, stats(mean)

//FIGURE 6. Ex-post Treatment Group vs. Control Group - Investment and Staff Expenses

tabstat l3Dinvestment l2Dinvestment l1Dinvestment Dinvestment f1Dinvestment f2Dinvestment f3Dinvestment if Lpung==0, stats(mean)
tabstat l3Dinvestment l2Dinvestment l1Dinvestment Dinvestment f1Dinvestment f2Dinvestment f3Dinvestment if Lpung==1, stats(mean)

tabstat l3Dstaffexpenses l2Dstaffexpenses l1Dstaffexpenses Dstaffexpenses f1Dstaffexpenses f2Dstaffexpenses f3Dstaffexpenses if Lpung==0, stats(mean)
tabstat l3Dstaffexpenses l2Dstaffexpenses l1Dstaffexpenses Dstaffexpenses f1Dstaffexpenses f2Dstaffexpenses f3Dstaffexpenses if Lpung==1, stats(mean)


//FIGURE C1 and FIGURE C2. Trends in Financial Statistics
**Median is used instead if mean given the ratios distribution

foreach i in leverageratio icr roepreferred{
g l1`i'= l.`i'
g l2`i'= l.l1`i'
g l3`i'= l.l2`i'
g f1`i'= f.`i'
g f2`i'= f.f1`i'
g f3`i'= f.f2`i'
}

tabstat l3leverageratio l2leverageratio l1leverageratio leverageratio f1leverageratio f2leverageratio f3leverageratio if Ldisg==0, stats(median)
tabstat l3leverageratio l2leverageratio l1leverageratio leverageratio f1leverageratio f2leverageratio f3leverageratio if Ldisg==1, stats(median)

tabstat l3icr l2icr l1icr icr f1icr f2icr f3icr if Ldisg==0, stats(median)
tabstat l3icr l2icr l1icr icr f1icr f2icr f3icr if Ldisg==1, stats(median)

tabstat l3roepreferred l2roepreferred l1roepreferred roepreferred f1roepreferred f2roepreferred f3roepreferred if Ldisg==0, stats(median)
tabstat l3roepreferred l2roepreferred l1roepreferred roepreferred f1roepreferred f2roepreferred f3roepreferred if Ldisg==1, stats(median)

tabstat l3leverageratio l2leverageratio l1leverageratio leverageratio f1leverageratio f2leverageratio f3leverageratio if Lpung==0, stats(median)
tabstat l3leverageratio l2leverageratio l1leverageratio leverageratio f1leverageratio f2leverageratio f3leverageratio if Lpung==1, stats(median)

tabstat l3icr l2icr l1icr icr f1icr f2icr f3icr if Lpung==0, stats(median)
tabstat l3icr l2icr l1icr icr f1icr f2icr f3icr if Lpung==1, stats(median)

tabstat l3roepreferred l2roepreferred l1roepreferred roepreferred f1roepreferred f2roepreferred f3roepreferred if Lpung==0, stats(median)
tabstat l3roepreferred l2roepreferred l1roepreferred roepreferred f1roepreferred f2roepreferred f3roepreferred if Lpung==1, stats(median)

//TABLE B1. Financial Statistics by Usage and Type of Debt Covenants

tabstat revenue debt cash assets investment staffexpenses roepreferred gearingratiopreferred dte icr, stats(mean median sd)

//TABLE B2. Summary Statistics ICC Firms 

g postgfc = (year>2010)
tabstat revenue debt cash assets investment staffexpenses roepreferred gearingratiopreferred dte icr if covtype_c==1, stats(p25 median p75) by(postgfc)

//TABLE C1.  Test for parallel trends
bysort id: g yearcount = _n
g year_Ldisg = yearcount if Ldisg==1
bysort id: egen maxyear_Ldisg = max(year_Ldisg)
bysort id: egen minyear_Ldisg = min(year_Ldisg)
replace year_Ldisg = maxyear_Ldisg if Ldisg==0

xtreg Dinvestment $controlvars i.Ldisg#c.year if (yearcount<=year_Ldisg), fe robust
lincom c.year#0.Ldisg - c.year#1.Ldisg, level(95)
xtreg Dstaffexpenses $controlvars i.Ldisg#c.year if (yearcount<=year_Ldisg), fe robust
lincom c.year#0.Ldisg - c.year#1.Ldisg, level(95)
